/*Logic: Create a random sequence of size n-2. For each sequence, calculate the degree of each node by looking at number of times it occurs in the sequence. Then, for each number in the sequence,find lowest numbered node with degree 1 and add an edge. Decrement their degree. At the end,when there are two vertices left of degree 1, add an edge between them. Then add edges between the leaf nodes to form cycle.*/

#include<iostream>
#include<cstdlib>
#include<stdio.h>
#include<ctime>
using namespace std;
void print_matrix(long int n,long int m);
long int compdeg(long int i,long int a[500][500]);                                             //Declaring functions and global variables
void construct_tree_halin(long int a[500]);
long int n,m,store[1000],se[500],adj[500][500],storemat[1000][1000];
int main()
{
	cout<<"Enter number of vertices\n";
   	cin>>n;
	cout<<"Enter number of Halin graphs to be returned\n";                  //Taking inputs
	cin>>m;
	freopen("halin.txt","w",stdout);
	print_matrix(n,m);
	return 0;
}
void print_matrix(long int a,long int b)
{
	long int i,j,counter=1,s,r,counter5=0,p,flag=0,flag2=0,u,ctr2=1,ctr4=0,o[500][500],d,f,g,x,z,q;
	srand(time(0));
	while(ctr2<=b)
	{
		for(i=1;i<=n;i++)
		{
			for(j=1;j<=n;j++)
			{
				adj[i][j]=0;                              //Initialising the matrix
			}
		}
		for(i=1;i<=a-2;i++)
		{
			se[i]=0;
			se[i]=(rand()%a)+1;                              //Taking random sequence as input
		}
		for(p=2;p<=counter;p++)                               	 //Checking if input sequence is same previous sequence
		{
			for(j=1,r=((p-2)*(a-2))+1;j<=a-2,r<=(p-1)*(a-2);j++,r++)
			{
				if(store[r]==se[j])    			//Checking it from stored sequences
				{
					counter5++;
				}
			}
			if(counter5==a-2)                               
			{
				flag=1;
				break;
			}
			else
				flag=0;
			counter5=0;
		}
		if(flag!=1)                                             //Converting sequence into a tree if not taken already
		{
			for(s=((counter-1)*(a-2))+1,j=1;s<=counter*(a-2),j<=a-2;s++,j++)
			{
				store[s]=se[j]; 
			}  
			construct_tree_halin(se);                       //Constructing tree and halin graph from the sequence
			for(i=1;i<=n;i++)
			{
				for(j=1;j<=n;j++)
				{
					o[i][j]=adj[i][j];              //Copying the matrix
				}
		
			}
			for(u=2;u<=ctr2;u++)                           //Checking if halin matrix is same as previous matrices
			{
				for(q=1;q<=n;q++)
				{
					for(z=1,x=((u-2)*n)+1;z<=n,x<=(u-1)*n;z++,x++)
					{
						if(storemat[q][x]==o[q][z])    //Checking from stored matrices
						{
							ctr4++;
						}
					}
				}
				if(ctr4==n*n)                               
				{
				flag2=1;
				break;
				}
				else
				flag2=0;
				ctr4=0;
			}
			if(flag2!=1)                                      //Displaying matrix if it is not displayed already
			{
				cout<<"Halin Graph:"<<ctr2<<'\n';
				for(d=1;d<=n;d++)
				{
					for(f=((ctr2-1)*n)+1,g=1;f<=ctr2*n,g<=n;f++,g++)
					{
						storemat[d][f]=o[d][g]; 
                				cout<<adj[d][g]<<' '; 
					}  
					cout<<'\n';                                                  
				}
				ctr2++;                                  //Incrementing counter for matrices
			}
			cout<<'\n';
			ctr4=0;                                                 
			counter++;                                  //Incrementing counter for sequences
		}
		counter5=0;                                         //Initialising values
	}
}
void construct_tree_halin(long int a[500])                               //Constructs tree and halin graph from the sequence
{
	long int i,j,degree[500],k,b[500][500],d[500];
	for(i=1;i<=n;i++)
	{
		degree[i]=1;                                        //Assigning degree of every node as 1
	}
	for(i=1;i<=n;i++)
	{
		for(j=1;j<=n-2;j++)
		{
			if(a[j]==i)
			{
				degree[i]=degree[i]+1;              //If a node is present in the sequence, increment the degree 
			}
		}
	}
	for(k=1;k<=n;k++)
	{
		for(i=1;i<=n-2;i++)            //For each number in the sequence,find lowest numbered node with degree 1 and add an edge
		{
			if(a[i]==k)
			{
				for(j=1;j<=n;j++)
				{
					if(degree[j]==1)
					{
						adj[k][j]=1;
						adj[j][k]=1;
						degree[k]=degree[k]-1;    //Decrement the degree if an edge is created in the tree
						degree[j]=degree[j]-1;
						break;
					}
				}
			}
		}
	}
	for(i=1;i<=n;i++)
	{
		for(j=1;j<=n;j++)
		{
			if(i!=j && degree[i]==1 && degree[j]==1)          //Find the two nodes with degree 1 and add an edge between them
			{
				adj[i][j]=1;
				adj[j][i]=1;
			}
		}
	}
	for(i=1;i<=n;i++)
	{
		for(j=1;j<=n;j++)
		{
			b[i][j]=adj[i][j];                                //Copying the created tree
		}
		
	}
	for(i=1;i<=n;i++)
	{
		for(j=1;j<=n;j++)
		{
			if(i!=j && compdeg(i,b)==1 &&  compdeg(j,b)==1)  //Creating Halin graph by adding edges b/w leaves
			{
				adj[i][j]=1;
				adj[j][i]=1;
			}
		}
	}
}
long int compdeg(long int i,long int a[500][500])                                           //Finding out degree of each vertex
{
	long int counter=0,j;
	for(j=1;j<=n;j++)
	{
		if(a[i][j]==1 || a[j][i]==1)
		{
			counter++;                                          //Incrementing counter
		}
	}
	return counter;
}
