/*Logic: For every vertex in the graph in parallel, find the neighbourhood of the graph and check if the neighbourhood graph is complete graph.Then while there are such vertices in the graph, keep removing such vertex and edges connected with that vertex in parallel. The graph keeps getting updated until there are such vertices. When there are no such vertices in the updated graph, if the graph is empty, then it is chordal. Else it is not chordal. */

#include<iostream>
#include<cstdlib>
#include<stdio.h>
#include<ctime>
#include<omp.h>
using namespace std;
bool vertex_check(long int k,long int a[500][500]);
bool check_chordal(long int a[500][500]);
long int compdeg(long int a[500][500]);
long int n,m,adj[500][500],store[1000][1000]peo[500],pe;
int main()
{
	long int i,j,counter=1,cop[500][500],s,r,counter5=0,p,flag=0;
	srand(time(0));
	cout<<"Enter number of vertices\n";
	cin>>n;
	cout<<"Enter number of chordal graphs to be returned\n";            //Taking inputs
	cin>>m;
	freopen("chordal_parallel.txt","w",stdout);
	while(counter<=m)
	{	
		#pragma omp parallel for
		for(i=1;i<=n;i++)
		{
			#pragma omp parallel for
			for(j=1;j<=n;j++)
			{
				cop[i][j]=0;
				cop[i][j]=(rand()%2)+0;                     //Taking binary matrix as input
				adj[i][j]=cop[i][j];
				adj[j][i]=cop[i][j];
				adj[i][i]=0;
				cop[j][i]=cop[i][j];
				cop[i][i]=0;
			}
		}
		if(check_chordal(adj))                                  //Checking whether the graph is chordal
		{
			#pragma omp parallel for
			for(p=2;p<=counter;p++)                         //Checking if input matrix is same previous matrices
			{
				for(i=1;i<=n;i++)
				{
					for(j=1,r=((p-2)*n)+1;j<=n,r<=(p-1)*n;j++,r++)
					{
						if(store[i][r]==cop[i][j])    //Checking from stored matrices
						{
							counter5++;
						}
					}
				}
				if(counter5==n*n)                               
				{
				flag=1;
				}
				else
				flag=0;
				counter5=0;
			}
			if(flag!=1)                                      //Displaying matrix if it is not displayed already
			{
				cout<<"Chordal matrix number:"<<counter<<'\n';
				for(i=1;i<=n;i++)
				{
					for(s=((counter-1)*n)+1,j=1;s<=counter*n,j<=n;s++,j++)
					{
						store[i][s]=cop[i][j]; 
                				cout<<cop[i][j]<<' '; 
					}  
					cout<<'\n';                                                  
				}
				cout<<"Partial elimination ordering for the chordal graph is: ";
				for(i=1;i<=pe-1;i++)
				{
					cout<<peo[i]<<' ';
				}
				cout<<'\n';
				counter++;                                  //Incrementing counter
			}
			cout<<'\n';
			counter5=0;
		}
	}
    	return 0;
}
bool check_chordal(long int a[500][500])
{
	long int counter=0,i,j,visited[500];
	int ctr=0;
	pe=1;
	for(i=1;i<=n;i++)
	{
		visited[i]=0;
	}
	#pragma omp parallel while
	while(1)                                                        //Removing the simplicial vertices repeatedly.
	{
		ctr=0;
		#pragma omp parallel for
		for(i=1;i<=n;i++)
		{
			if(vertex_check(i,a) && visited[i]==0)
			{
				ctr++;
			}
		}
		if(ctr==0)
		{
			break;
		}
		#pragma omp parallel for
		for(i=1;i<=n;i++)
		{
			if(vertex_check(i,a) && visited[i]==0)                  //Removing the vertex if it satisfies vertex check
			{
				peo[pe]=i;
				pe++;
				visited[i]=1;
				for(j=1;j<=n;j++)
				{
					a[i][j]=0;
					a[j][i]=0;
				}
				break;
			}
		}
	}
	#pragma omp parallel for
	for(i=1;i<=n;i++)
	{
		#pragma omp parallel for
		for(j=1;j<=n;j++)
		{
			if(a[i][j]==0)                    //Checking if the graph is empty
			{
				counter++;
			}
		}
	}
	if(counter==n*n)
		return true;
	else
		return false;
}
bool vertex_check(long int k,long int adj[500][500])
{
	long int j,i,m,notnei=0,nei,l;
	long int b[500][500];
	#pragma omp parallel for
	for(i=1;i<=n;i++)
	{
		#pragma omp parallel for
		for(j=1;j<=n;j++)
		{
			b[i][j]=adj[i][j];                             //Copying the matrix 
		}
	}
	#pragma omp parallel for
	for(i=1;i<=n;i++)
	{
		if(adj[k][i]!=1)
		{
			notnei++;
			#pragma omp parallel for
			for(m=1;m<=n;m++)
			{
				b[i][m]=0;b[m][i]=0;                   //Removing the vertices other than neighbours of the vertex
			}
		}
	}
	nei=n-notnei;                                                     
	l=(nei*(nei-1));                                              //Checking whether neighbours of the vertex form a complete graph
	if(compdeg(b)==l)
	return true;
	else 
	return false;
}
long int compdeg(long int a[500][500])                                      //Counting number of edges in the graph
{
	long int i,j,counter=0;
	#pragma omp parallel for
	for(i=1;i<=n;i++)
	{
		#pragma omp parallel for
		for(j=1;j<=n;j++)
		{
			if(i!=j && a[i][j]==1)
			{
				counter++;                                       //Incrementing the counter
			}
		}
	}
	return counter;
}
